/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk.client;

import com.tplink.eap.cloudsdk.client.HelloCloudDelegate;
import com.tplink.eap.cloudsdk.client.StopConnReason;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloCloud {
    private static final Logger logger = LoggerFactory.getLogger(HelloCloud.class);
    public static final int TIMEOUT_RETRY_MAX_TIME = 3;
    public static final int TIMEOUT_RETRY_INTERVAL_MS = 5000;
    public static final String KEY_TCSP_VER = "tcspVer";
    public static final String KEY_DEVICE_ID = "deviceId";
    public static final String KEY_CLOUD_USER_NAME = "cloudUserName";
    public static final String KEY_DEVICE_NAME = "deviceName";
    public static final String KEY_ALIAS = "alias";
    public static final String KEY_DEVICE_MAC = "deviceMac";
    public static final String KEY_HW_ID = "hwId";
    public static final String KEY_DEVICE_MODEL = "deviceModel";
    public static final String KEY_DEVICE_HW_VER = "deviceHwVer";
    public static final String KEY_DEVICE_TYPE = "deviceType";
    public static final String KEY_FW_ID = "fwId";
    public static final String KEY_OEM_ID = "oemId";
    public static final String KEY_FW_VER = "fwVer";
    public static final String KEY_IP = "ip";
    public static final String KEY_MASK = "mask";
    public static final String KEY_AUTH_CODE = "authCode";
    public static final String KEY_CONTROLLER_VERSION = "controllerVersion";
    public static final String METHOD_VAL_HELLO_CLOUD = "helloCloud";
    public static final String TCSP_VER_VAL = "1.2";
    public static final String KEY_TCSP_STATUS = "tcspStatus";
    public static final String KEY_FW_DL_PAGE = "fwDlPage";
    public static final String KEY_TCSP_INFO = "tcspInfo";
    public static final String KEY_ILLEGAL_TYPE = "illegalType";
    public static final String KEY_CACHE_SVR = "cachedSvr";
    public static final String KEY_VALID_TIME_ON_DEVICE = "validTimeOnDevice";
    public static final String KEY_STOP_CONNECT = "stopConnect";
    public static final String KEY_RECONNECT_TIME = "reconnectTime";
    private HelloCloudDelegate delegate;
    private ClientType clientType;
    private int illegalType = -1;
    private StopConnReason stopConnect = StopConnReason.DEFAULT_NORMAL;
    private int reconnectTime = 0;
    private String domain;
    private int port;
    private int validTimeOnDevice;

    public HelloCloud(HelloCloudDelegate delegate, ClientType clientType) {
        this.delegate = delegate;
        this.clientType = clientType;
    }

    public int getIllegalType() {
        return this.illegalType;
    }

    public void setIllegalType(int illegalType) {
        this.illegalType = illegalType;
    }

    public StopConnReason getStopConnect() {
        return this.stopConnect;
    }

    public void setStopConnect(StopConnReason stopConnect) {
        this.stopConnect = stopConnect;
    }

    public long getReconnectTime() {
        return this.reconnectTime;
    }

    public void setReconnectTime(int reconnectTime) {
        this.reconnectTime = reconnectTime;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getValidTimeOnDevice() {
        return this.validTimeOnDevice;
    }

    public void setValidTimeOnDevice(int validTimeOnDevice) {
        this.validTimeOnDevice = validTimeOnDevice;
    }

    public JSONObject getRequest(int msgId) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        JSONObject request = new JSONObject();
        request.put((Object)"id", (Object)msgId);
        request.put((Object)"method", (Object)METHOD_VAL_HELLO_CLOUD);
        JSONObject params = this.delegate.getRequestParams();
        if (params == null) {
            logger.warn("Request params from delegate is in invalid format.");
            return request;
        }
        params.put((Object)KEY_TCSP_VER, (Object)TCSP_VER_VAL);
        request.put((Object)"params", (Object)params);
        if (this.clientType.equals((Object)ClientType.SEF_CLIENT)) {
            params = request.getJSONObject("params");
            params.put((Object)KEY_AUTH_CODE, (Object)"");
            params.put((Object)KEY_AUTH_CODE, (Object)AuthCodeGenerator.generate(request));
        }
        return request;
    }

    public void onResponse(JSONObject response) {
        this.delegate.onResponse(response);
        if (response == null || response.getInt("error_code") != 0 || !response.has("result")) {
            return;
        }
        JSONObject result = response.getJSONObject("result");
        if (result.has(KEY_ILLEGAL_TYPE) && (this.illegalType = result.getInt(KEY_ILLEGAL_TYPE)) != 0) {
            if (result.has(KEY_RECONNECT_TIME)) {
                this.reconnectTime = result.getInt(KEY_RECONNECT_TIME);
            }
            if (this.reconnectTime <= 0) {
                this.reconnectTime = new Random().nextInt(1023) + 2;
            }
        } else {
            if (result.has(KEY_CACHE_SVR) && result.has(KEY_VALID_TIME_ON_DEVICE)) {
                String[] array = result.getString(KEY_CACHE_SVR).split(":");
                this.domain = array[0];
                this.port = Integer.parseInt(array[1]);
                this.validTimeOnDevice = result.getInt(KEY_VALID_TIME_ON_DEVICE);
            }
            if (result.has(KEY_STOP_CONNECT)) {
                this.stopConnect = StopConnReason.valueOf(result.getInt(KEY_STOP_CONNECT));
            }
            if (result.has(KEY_RECONNECT_TIME)) {
                this.reconnectTime = result.getInt(KEY_RECONNECT_TIME);
            }
        }
    }

    public void reset() {
        this.validTimeOnDevice = 0;
        this.port = 0;
        this.domain = null;
        this.reconnectTime = 0;
        this.stopConnect = StopConnReason.DEFAULT_NORMAL;
        this.illegalType = -1;
    }

    private static class AuthCodeGenerator {
        private static final int HARDWARE_ID_LEN = 32;
        private static final int HARDWARE_ID_LEN_HEAD = 20;
        private static final int HARDWARE_ID_LEN_TAIL = 12;
        private static final int MD5_STR_LEN = 32;

        private AuthCodeGenerator() {
        }

        public static String generate(JSONObject request) throws UnsupportedEncodingException, NoSuchAlgorithmException {
            JSONObject params = request.getJSONObject("params");
            byte[] hwId = params.getString(HelloCloud.KEY_HW_ID).getBytes("UTF-8");
            byte[] reqBytes = request.toString().getBytes("UTF-8");
            ByteBuffer reqWithMd5 = ByteBuffer.allocate(reqBytes.length + 32);
            reqWithMd5.put(hwId, 0, 20);
            reqWithMd5.put(reqBytes, 0, reqBytes.length);
            reqWithMd5.put(hwId, 20, 12);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] digest = md5.digest(reqWithMd5.array());
            StringBuilder digestHex = new StringBuilder();
            byte[] byArray = digest;
            int n = digest.length;
            int n2 = 0;
            while (n2 < n) {
                byte digestByte = byArray[n2];
                digestHex.append(String.format("%02x", digestByte));
                ++n2;
            }
            return digestHex.toString();
        }
    }

    public static enum ClientType {
        SEF_CLIENT,
        SERVICE_CLIENT;

    }
}

